# UPSRT
#### A Pokémon + Dance Game adventure for StepMania 5


## About
This is the GitHub repository for UPSRT, a Pokémon + Dance Game themed adventure for the [StepMania 5](https://github.com/stepmania/stepmania) engine.  UPSRT was created as a side event for the U.P.S. StepMania tournament held in January 2016.

## System Requirements
You'll need to have [StepMania 5.0.10](https://github.com/stepmania/stepmania/releases/tag/v5.0.10) installed to run UPSRT properly.

Additionally, there are two settings in *Preferences.ini* that need to be manually set for UPSRT to function properly.  The location of *Preferences.ini* depends on your operating system, and [is documented here](https://github.com/stepmania/stepmania/wiki/Manually-Changing-Preferences).

```ini
OnlyDedicatedMenuButtons=0
VideoRenderers=opengl,d3d
```

Please note that if you are using Mac OS X or Linux, the second of those preferences, *VideoRenderers*, will already be set properly as Direct3D rendering is not supported for OS X or Linux.

Finally, UPSRT only works in the "dance" game mode, so if your copy of StepMania 5.0.10 is currently set to *pump* or *techno*, please switch it to **dance** before starting.

UPSRT was designed with a **16:9 aspect ratio** in mind, but it has been tested in 4:3 and 16:10 and should work fine in those, too.

Due to some engine-side changes and deprecations that will occur in StepMania 5.1.0, it is unlikely that UPSRT will work in that version of StepMania.  At this time, there are no plans to update UPSRT to support StepMania 5.1.0, but that may change in the future.


## Screenshots

Please visit the [UPSRT imgur album](http://imgur.com/a/lJZ1r) to see screenshots.


## Language/Translation Support

This release includes full language support for English, Spanish, and French.

There is a Korean translation included, but StepMania's support for Hangul bitmap fonts is currently limited, so many of the characters don't render properly. Sorry about that.

A future release of UPSRT may include a Japanese translation.


## Downloads

The content for UPSRT is split into two packages: the theme (hosted here on GitHub) and the songs.

[UPSRT Theme (16MB)](https://github.com/dguzek/UPSRT/releases/)

[UPSRT Song Pack (21MB)](http://www.mediafire.com/download/hb5b9xjp0onkoyl/UPSRT.zip)

## Troubleshooting

**The screen displays as all white after getting through the introduction!**

This is a render-to-texture bug in StepMania that occurs in some Windows computers when `d3d` is set as the primary VideoRenderer.  You will need to set `opengl` as your primary VideoRenderer to resolve this issue.  Refer to the System Requirements section above.

**The screen displays as all black after getting through the introduction!**

This bug seems to only occur on Windows computers and seems to be permissions based.  A few things that can cause this include:

**A.** If the StepMania program is installed to `C:\Program Files` you will encounter permissions errors like this one.  Assuming you've already installed StepMania to *Program Files*, you'll need to uninstall, and then reinstall to somewhere within your user profile folder, for example your *Desktop* or *Documents*.

**B.** If the UPSRT pack is being loaded via the `AdditionalFolders=` or `AdditionalSongFolders=` in *Preferences.ini* it seems that this can cause permissions errors on Windows, too.  You can resolve this by placing both the UPSRT theme and song pack in their appropriate sub-folders within `%appdata%/StepMania 5/` as [documented here](https://github.com/stepmania/stepmania/wiki/User-Data-Locations).

## License

UPSRT is Copyright 2015 – 2016 [Dan Guzek](https://github.com/dguzek/), [Caitlin Schaeppi](http://unboundembrace.weebly.com/), [Alan James](https://www.youtube.com/user/taro4012)

License: [No License](http://choosealicense.com/no-license/)